from train_module import * 
os.chdir(os.path.dirname(os.path.abspath(__file__)))

trainer_params = {
    'epochs': 1000,
    'train_pomo_size': 32,
    'num_param': 1,
    'num_local': 8*32,
    'accumulation':8
}

env_params ={
    'batch_size' : 4,
    'pomo_size': 32, 
    'job_num' : 25,
    'machine_num': 3,
    'mode': 'rand',  # "fine_tuning"
    'fine_tuning_path' : ".result/model-1000.pt",
    'process_time_params': {
        's_max': 10,
        'T': 0.8,  
        'R': 0.4,
        'm_p': 0.5
    }
    }

model_params = {
    'input_dim': 6, 
    'embedding_dim':64, 
    'head_num' : 8,
    'encoder_layer_num': 3,
    'latent_cont_dim': 2,
    'latent_disc_dim': 6
}

optimizer_params = {
    'optimizer': {
        'lr': 1e-4,
        'weight_decay': 1e-6, 
    }
}

UPMSP_Trainer1 = UPMSP_Trainer(
                        env_params,
                        model_params,
                        optimizer_params,
                        trainer_params,
                    )
UPMSP_Trainer1.run()